'------------------------------------------------------------------------------
'                             5110.BAS
'          Code to talk to Nokia 5110/6110 GSM phone by Mark Voevodin
'
'          Most of this code has come from sniffing the data stream between
'          Nokia software and mobile phone.
'
'          Program originally written in Delphi on PC, then converted to BASCOM-AVR
'
'          This program requires a 11.059Mhz Crystal to communicate at 115,200 baud
'          for FBUS communication.
'          Tested with DAU9 cable to 5110, with external power to activate the
'          circuitry in the DAU9.
'
'          Project started MAY 2000
'          Ported to BASCOM AUG 2001
'          Last Update MAY 2002
'
'
'
'          The code as it stands talks to the Nokia 5110 and displays
'          the Hardware/Software Version and IMEI number on a 40 * 2 line LCD
'          Incoming SMS messages will be decoded and displayed onto the
'          LCD, but only the first 80 characters of the message.
'          Incoming callers number is displayed for voice calls
'          Other status messages can be shown, or are in process of being
'          converted from Delphi.
'
'          AVR used was HotChip mini
'
'   ToDo:  Send SMS's
'          Get external input to trigger sending SMS's
'
'------------------------------------------------------------------------------



$regfile = "8535def.dat"
$crystal = 11059000
$baud = 115200
$lib "nokia.lib"
$external Blockcheck
Declare Sub Blockcheck(x As Byte , Byval Y As Byte )

'_lpt_data Alias Portc                                       ' data port connected to d0-d7 of LPT
'_lpt_control Alias Portb                                    ' portb used for the control pins
'_lpt_status Alias Pinb
'_lpt_busy Alias 1                                           ' busy is pinb.1
'_lpt_strobe Alias 2                                         ' strobe is portb.2

Const Cmaxchar = 160                                        'Max number of characters
Dim Rxflag As Bit                                           'a flag for signalling a received character
Dim Rxcount As Byte                                         'RX byte counter
Dim Rx(cmaxchar) As Byte                                    'Rx Buffer
Dim Tx(cmaxchar) As Byte                                    'TX Buffer
Dim X As Integer
Dim Y As Integer
Dim Z As Integer
Dim Currentstate As Integer                                 'State Machine
Dim Waitingforreplyflag As Bit                              'Flag to indicate that message sent and Waiting for reply
Dim Waitingformsg As Bit                                    'Flag to indicate that required message has been recv
Dim Abort As Bit
Dim Lookingforflag As Bit                                   'Flag to indicate we are looking for something
Dim Lookfor As Byte                                         'The byte we are looking for
Dim Count As Byte
Dim B1 As Byte
Dim Sx As Byte
Dim Seq As Byte
Dim Msgnumber As Byte
'Variables for Unpack 7 - SMS messages are encoded as 7 bit as per
'ETSI GSM 03.38,03.40,07.05,07.07
Dim Msgposition As Byte
Dim Xshift As Byte
Dim Msgval As Byte
Dim Current8bit As Byte
Dim Currentbit As Byte
Dim Msgloop As Byte
Dim Msgbit As Byte
Dim Msgz As Byte
Dim Msgy As Byte
Dim Msglen As Byte


Dim Az As Byte
Dim Bz As Byte
Dim Cz As Byte
Dim Dz As Byte
Dim Vz As Byte
Dim Yz As Byte
Dim Zz As Byte

'Dim Sframe(60) As Byte
Dim Temp(16) As Byte
Dim Temp1(16) As Byte

On Urxc Rec_isr                                             'define serial receive ISR
Enable Urxc                                                 'enable receive isr
Enable Interrupts                                           'enable interrupts to occur


Printbin &H55
Cls
Lcd "Nokia 5110 - SMS Decode v1.06"
Lowerline
Lcd "by Mark Voevodin - Copyright 2002"
Wait 3

'Zero variables
  Y = 0
  Currentstate = 0
  Waitingforreplyflag = 0
  Waitingformsg = 0
  Lookingforflag = 0
  Lookfor = 0
  Seq = &H40

 Cls                                                        'Clear LCD

Gosub Resetsoft                                             'Reset phone to start message
Wait 1

'Main Loop
Do

  If Rxflag = 1 Then                                        'we received something
     Disable Serial                                         'Disables URXC, UDRE and UTXC
      If Lookingforflag = 0 Then                            'We aren't already looking for characters
        If Rx(rxcount) = &H1E Then                          'Start of packet
          Rxcount = 1                                       'Reset start position
          Rx(rxcount) = &H1E                                'Reset packet to start character
        End If
      End If

      If Rxcount >= 2 Then                                  'Need to test the 2nd byte, so we need at least 2 bytes
        If Rx(2) <> 0 Then                                  'If zero can't test
          If Rxcount = 10 Then                              'need at least 10 bytes of packet
            If Rx(4) = &H7F Then                            'This indicates an ACK packet
            Lookingforflag = 0
            Waitingforreplyflag = 0                         'We aren't looking for a reply now
            Rxcount = 1                                     'Reset start position
            Rx(rxcount) = &H1E                              'Reset packet to start character
            End If
          End If
          If Rxcount = 6 Then                               'Need at least 6 bytes to work out packet length
            Y = Rx(6)
            Z = Y Mod 2
            Z = Z + Y
            Lookfor = 8 + Z                                 'This is packet length, so we need to loop til we get this number
            Lookingforflag = 1                              'Flag that we are waiting for more bytes
          End If

          If Rxcount = Lookfor Then                         'we have the full number of bytes for this packet
            Lookingforflag = 0                              'Reset Flag, we not looking for any more bytes
              If Rx(4) <> &H7F Then                         'Not an ACK message
              Gosub Sendack
              Gosub Processpacket                           'We have a valid packet, so decode
              End If
          End If

        End If
      End If


     'now check for buffer full
     If Rxcount = Cmaxchar Then                             'buffer full
        Rxcount = 0                                         'reset character counter
     End If

     Reset Rxflag                                           'reset receive flag
     Enable Serial                                          'Enable serial interupts


  End If


  If Waitingforreplyflag = 0 Then                           'We not waiting for a reply
  Select Case Currentstate
  Case Is = 0:
  If Waitingforreplyflag = 0 Then
   Waitingforreplyflag = 1
   Lcd "0"
   Gosub Initframe
   Restore Nokiamsg1
   Sx = 12
   Gosub Sendframe
   Gosub Getseq
   Tx(12) = Seq
   Call Blockcheck(tx(1) , 6)
   Printbin Tx(1) ; 14
  End If

  Case Is = 1:
  If Waitingforreplyflag = 0 Then
   Waitingforreplyflag = 1
   Lcd "1"
   Restore Nokiamsg2
   Sx = 14
   Gosub Sendframe
   Gosub Getseq
   Tx(13) = Seq
   Call Blockcheck(tx(1) , 7)
   Printbin Tx(1) ; 16
  End If
  Case Is = 2:
  'If Waitingformsg = 1 Then
  If Waitingforreplyflag = 0 Then
   Waitingforreplyflag = 1
   Lcd "2"
   Restore Nokiamsg3
   Sx = 16
   Gosub Sendframe
   Gosub Getseq
   Tx(15) = Seq
   Call Blockcheck(tx(1) , 8)
   Printbin Tx(1) ; 18
   Waitingformsg = 0
  End If
 'End If
  Case Is = 3:
  If Waitingforreplyflag = 0 Then
   Waitingforreplyflag = 1
   Lcd "3"
   Restore Nokiamsg4
   Sx = 14
   Gosub Sendframe
   Gosub Getseq
   Tx(13) = Seq
   Call Blockcheck(tx(1) , 7)
   Printbin Tx(1) ; 16
  End If
  Case Is = 4:
  If Waitingforreplyflag = 0 Then
   Waitingforreplyflag = 1
   Lcd "4"
   Restore Nokiamsg5
   Sx = 16
   Gosub Sendframe
   Gosub Getseq
   Tx(15) = Seq
   Call Blockcheck(tx(1) , 8)
   Printbin Tx(1) ; 18
  End If
  Case Is = 5:
  If Waitingforreplyflag = 0 Then
   Waitingforreplyflag = 1
   Lcd "5"
   Restore Nokiamsg6
   Sx = 12
   Gosub Sendframe
   Gosub Getseq
   Tx(12) = Seq
   Call Blockcheck(tx(1) , 6)
   Printbin Tx(1) ; 14
  End If
  Case Is = 6:
  If Waitingformsg = 1 Then
   If Waitingforreplyflag = 0 Then
   Waitingforreplyflag = 1
   Lcd " 6 ";
   Restore Nokiamsg7
   Sx = 54
   Gosub Sendframe
   Tx(11) = Temp1(1)
   Tx(12) = Temp1(2)
   Tx(13) = Temp1(3)
   Tx(14) = Temp1(4)
   Tx(15) = Temp1(5)
   Tx(16) = Temp1(6)
   Tx(17) = Temp1(7)
   Tx(18) = Temp1(8)
   Tx(19) = Temp1(9)
   Tx(20) = Temp1(10)
   Tx(21) = Temp1(11)
   Tx(22) = Temp1(12)
   Tx(23) = Temp1(13)
   Tx(24) = Temp1(14)
   Tx(25) = Temp1(15)
   Tx(26) = Temp1(16)
   Gosub Getseq
   Tx(53) = Seq
   Call Blockcheck(tx(1) , 27)
   Printbin Tx(1) ; 56
   Lcd "Seq:" ; Hex(seq);
   Waitingformsg = 0


  End If
  End If
  End Select

 End If

Loop

'Need to send this out, not normally before every message though
Initframe:
  For Sx = 1 To 30
  Printbin &H55                                             'initframe to phone
  Next
  Waitus 10
Return

Resetsoft:
  Printbin &H1E ; &H00 ; &H0C ; &H40 ; &H00 ; &H01 ; &H64 ; &H03 ; &H04 ; &H29 ; &H72 ; &H6F
  Cls
  Lcd "Reset Phone - Soft";
  Waitus 100
Return


Sendack:
'So work out an ACK message to transmit to reply to this packet
  Tx(1) = &H1E
  Tx(2) = &H00
  Tx(3) = Rx(2)
  Tx(4) = &H7F
  Tx(5) = &H00
  Tx(6) = &H02
  Tx(7) = Rx(4)
  Y = Rx(6)
  Z = 6 + Y
  Tx(8) = Rx(z)

  Call Blockcheck(tx(1) , 4)
  Waitus 10                                                 'Don't send reply straight away
  Printbin Tx(1) ; 10
Return



Processpacket:                                              'We got info in buffer, let's work out what it is

Select Case Rx(4)                                           'Message type held in this byte

Case Is = &H00:
                        'Monitoring values
Case Is = &H01:
    'Call Information');
     Select Case Rx(10)
     Case Is = &H02:
        'Call going msg'

     Case Is = &H03:
        Cls
        Lcd "Call in progress"
     Case Is = &H04:
        'Remote End Hung Up'
         Cls
         Lcd "Remote Hung Up"
     Case Is = &H05:
         Select Case Rx(13)
          Case Is = &H00:
             'Incoming Call No Number
             Cls
             Lcd "No number"
          Case Else
             'Incoming Call
             Cls
'             Lcd "Number Len ";
'             Lcd Rx(13) ;
             X = 13 + Rx(13)                                'Display calling number
             For Y = 14 To X
             Z = Rx(y)
               Lcd Chr(z);
             Next
        End Select

     Case Is = &H07:
      Cls
      Lcd "Call answered"

     Case Is = &H09:
        'Call terminated');
         Cls
         Lcd "Call terminated"
     Case Is = &H0A:
        Cls
        Lcd "Call msg"

     Case Is = &H40:
        Cls
        Lcd "Send DTMF/voice call"


     End Select
Case Is = &H02:
   'SMS Handling');
     Select Case Rx(10)
     Case Is = &H02:
        Cls
        Lcd "Message sent"

     Case Is = &H03:
        Cls
        Lcd "Send failed"

     Case Is = &H0E:
        'cls
        'Lcd "Initiate Ack"

     Case Is = &H10:
        Cls
        'Lcd "SMS Received"
        Msgnumber = Rx(12)
        Lcd "(";
        Lcd Str(msgnumber);
        Lcd ") ";
'        Lprint "(";
'        Lprint Str(msgnumber);
'        Lprint ") ";

        Msgval = Rx(15)
        If Msgval = 145 Then
        Lcd "+";
'        Lprint "+";
        End If
        X = Rx(14)
        Decr X
        For Y = 2 To X

        Msgval = Rx(y + 14)
        Rotate Msgval , Left , 4
        Lcd Hex(msgval);
'        Lprint Hex(msgval);
        Next

        Msgval = Rx(x + 15)
        Shift Msgval , Left , 4
        Shift Msgval , Right , 4
        Lcd Msgval;
'        Lprint Str(msgval);
        Lcd "  ";

        Msgval = Rx(31)
        If Msgval = 145 Then
        Lcd "+";
'        Lprint "+";
        End If
        X = Rx(14)
        Decr X
        For Y = 2 To X

        Msgval = Rx(y + 30)
        Rotate Msgval , Left , 4
        Lcd Hex(msgval);
'        Lprint Hex(msgval);
        Next
        Msgval = Rx(x + 31)
        Shift Msgval , Left , 4
        Shift Msgval , Right , 4
        Lcd Msgval;
'        Lprint Str(msgval);

        Lowerline
        Msgposition = 49
        Msglen = Rx(29)
        Gosub Unpack7

        Gosub Delsms
     Case Is = &H21:
       ' Lowerline
        'Lcd "Set Cell B OK"
     Case Is = &H23:
        Cls
        Lcd "Read Cell Broadcast"

     Case Is = &H31:
        Cls
        Lcd "SMS center OK"
     Case Is = &H32:
        Cls
        Lcd "SMS center ERROR"

     Case Is = &H34:
        Cls
        Lcd "SMS center received"
     Case Is = &H35:
        Cls
        Lcd "SMS center Recv error"

     End Select
Case Is = &H04:
   'Info about phone
     Select Case Rx(10)
     Case Is = &H04:
      '  Cls
       ' Lcd "Info from phone1"

        ' Lowerline
         '    For Y = 11 To 42
        '     Z = Rx(y)
         '      Lcd Chr(z);
        '     Next


     End Select

Case Is = &H64:
   'Info about phone
     Select Case Rx(10)
     Case Is = &H11:
'         Cls
 '        Lcd "Magic ";
         Waitingformsg = 1

'Goto Asdf
            'Populate the temp array with reqd bytes
    Z = 0
    For Y = 22 To 29
     Cz = 1 + Z
     Temp(cz) = Rx(y)
     Incr Z
    Next
    Z = 0
    For Y = 18 To 21
     Cz = 9 + Z
     Temp(cz) = Rx(y)
     Incr Z
    Next
    Z = 0
    For Y = 57 To 60
     Cz = 13 + Z
     Temp(cz) = Rx(y)
''     Lcd Hex(rx(y)) ; " ";
     Incr Z
    Next
    'Ok let work out the special bytes
Auth:

'Step1
For Zz = 1 To 12
  Cz = Zz + 1
  Az = Temp(cz)
  Bz = Az And 1
  If Bz = 1 Then
   Shift Temp(zz) , Left , 1
  End If
Next

'Step2
Vz = Temp(16) And 3
Select Case Vz
  Case Is = 1:
     Yz = Temp(14) And 7
     For Zz = 1 To 4
       Cz = Zz + Yz
       Az = Temp(cz)
       Cz = Zz + 12
       Bz = Temp(cz)
       Dz = Az Xor Bz
       Cz = Zz + Yz
       Temp(cz) = Dz

     Next
  Case Is = 2:
     Yz = Temp(14) And 7
     For Zz = 1 To 4
       Cz = Zz + Yz
       Az = Temp(cz)
       Cz = Zz + 12
       Bz = Temp(cz)
       Dz = Az Xor Bz
       Cz = Zz + Yz
       Temp(cz) = Dz

     Next
  Case Else
     Yz = Temp(15) And 7
     For Zz = 1 To 4
       Cz = Zz + Yz
       Az = Temp(cz)
       Cz = Zz + 12
       Bz = Temp(cz)
       Dz = Az Or Bz
       Cz = Zz + Yz
       Temp(cz) = Dz

     Next
End Select

'Step3
Dz = 0
For Zz = 1 To 16
Bz = Dz
Cz = Temp(zz)
Dz = Bz Xor Cz
Next
For Zz = 1 To 16
Cz = 17 - Zz
Az = Temp(cz)
Vz = Az And 6
Select Case Vz
  Case Is = 0:
    Yz = Temp(zz) Or Dz
  Case Is = 2:
    Yz = Temp(zz) Xor Dz
  Case Is = 4:
    Yz = Temp(zz) Xor Dz
  Case Is = 6:
    Yz = Temp(zz) And Dz
End Select

If Yz = Dz Then
Yz = &H2C
End If
If Temp(zz) = 0 Then
Yz = 0
End If
'Cz = Zz + 10
'Sframe(cz) = Yz
Temp1(zz) = Yz
Next

'For Zz = 1 To 16
'Cz = Zz + 10
'Sframe(cz) = Temp1(zz)
'Lcd Hex(temp1(zz)) ; " ";
'Next

'Wait 20
Asdf:

        Cls
        Lcd "IMEI:";


             For Y = 16 To 30
             Z = Rx(y)
               Lcd Chr(z);
             Next

        Lcd "   Model:";
             For Y = 32 To 36
             Z = Rx(y)
               Lcd Chr(z);
             Next
        Lowerline
        Lcd "PC:";
             For Y = 38 To 44
             Z = Rx(y)
               Lcd Chr(z);
             Next

        Lcd " HW:";
             For Y = 46 To 49
             Z = Rx(y)
               Lcd Chr(z);
             Next
        Lcd " FW:";
             For Y = 51 To 55
             Z = Rx(y)
               Lcd Chr(z);
             Next
     End Select

Case Is = &HD0:
   Cls
   Lcd "Power On Message"
   Currentstate = 0
   Lcd " Seq:" ; Hex(seq)
   Waitingforreplyflag = 0
   Wait 4

Case Is = &HD1:
   Cls
   Lcd "Info about phone 1"

Case Is = &HD2:
   'Info about phone
     Select Case Rx(10)
     Case Is = &H03:
       'Waitingformsg = 1
       ' Cls
       ' Lcd "Info from phone2"


       '      For Y = 11 To 42
       '      Z = Rx(y)
      '        Lcd Chr(z);
      '      Next


     End Select

Case Is = &HF4:
   Cls
   Lcd "Power On Message F4"
   Currentstate = 0
   Lcd " Seq:" ; Hex(seq)
   Waitingforreplyflag = 0
   Wait 4

End Select

Skipack:
Return

'Serial ISR
Rec_isr:
  If Rxcount < Cmaxchar Then                                'does it fit into the buffer?
     Incr Rxcount                                           'increase buffer counter
     Rx(rxcount) = Udr
  End If
  Rxflag = 1                                                'set flag, we got a byte
Return


'This is the REAL hard part!!!
'Due to limited SRAM, we have to decode 7bit to 8bit into the same buffer memory.
Unpack7:
Xshift = 0
For Msgloop = 1 To Msglen
  Current8bit = Rx(msgposition)
  Shift Current8bit , Right , Xshift
  Msgval = Current8bit And &H7F
  Xshift = Xshift + 7
  Msgbit = Xshift And 8
  If Msgbit = 8 Then
    Xshift = Xshift And &H07
    Incr Msgposition
    Msgy = Rx(msgposition)
    Msgz = 8 - Xshift
    Shift Msgy , Left , Msgz
    Shift Msgy , Right , 1
    Msgval = Msgval + Msgy
  End If

Current8bit = Msgval
Gosub Translate
Msgval = Current8bit

Lcd Chr(msgval);
'Lprint Chr(msgval);
Next
'Lprint Chr(12);
Return

Pack7:                                                      'This is just dummy code to take up space - needed when SMS sending working
Xshift = 0
For Msgloop = 1 To Msglen
  Current8bit = Rx(msgposition)
  Shift Current8bit , Right , Xshift
  Msgval = Current8bit And &H7F
  Xshift = Xshift + 7
  Msgbit = Xshift And 8
  If Msgbit = 8 Then
    Xshift = Xshift And &H07
    Incr Msgposition
    Msgy = Rx(msgposition)
    Msgz = 8 - Xshift
    Shift Msgy , Left , Msgz
    Shift Msgy , Right , 1
    Msgval = Msgval + Msgy
  End If

Current8bit = Msgval
Gosub Translate
Msgval = Current8bit

Lcd Chr(msgval);
'Lprint Chr(msgval);
Next
'Lprint Chr(12);
Return

Translate:
Currentbit = Lookup(current8bit , Dta)
Current8bit = Currentbit
Return

Sendframe:
  For Count = 1 To Sx
  Read B1 : Tx(count) = B1
  Next
  Incr Currentstate
Return


Getseq:
   Incr Seq
   If Seq > &H47 Then
   Seq = &H40
   End If
Return

Delsms:
   Restore Nokiamsg8
   Sx = 14
   For Count = 1 To Sx
   Read B1 : Tx(count) = B1
   Next
   Gosub Getseq
   Tx(12) = Msgnumber
   Tx(14) = Seq
   Call Blockcheck(tx(1) , 7)
   Printbin Tx(1) ; 16
Return

End                                                         'End Program


Dta:
Data 64 , &HA3 , 36 , &HA5 , &HE8 , &HE9 , &HF9 , &HEC
Data &HF2 , &HC7 , &H10 , &HD8 , &HF8 , &H13 , &HC5 , &HE5
Data 63 , 95 , 63 , 63 , 63 , 63 , 63 , 63
Data 63 , 63 , 63 , 63 , &HC6 , &HE6 , &HDF , &HC9
Data 32 , 33 , 34 , 35 , &HA4 , 37 , 38 , 39
Data 40 , 41 , 42 , 43 , 44 , 45 , 46 , 47
Data 48 , 49 , 50 , 51 , 52 , 53 , 54 , 55
Data 56 , 57 , 58 , 59 , 60 , 61 , 62 , 63
Data &HA1 , 65 , 66 , 67 , 68 , 69 , 70 , 71
Data 72 , 73 , 74 , 75 , 76 , 77 , 78 , 79
Data 80 , 81 , 82 , 83 , 84 , 85 , 86 , 87
Data 88 , 89 , 90 , &HC4 , &HD6 , &HD1 , &HDC , &HA7
Data &HBF , 97 , 98 , 99 , 100 , 101 , 102 , 103
Data 104 , 105 , 106 , 107 , 108 , 109 , 110 , 111
Data 112 , 113 , 114 , 115 , 116 , 117 , 118 , 119
Data 120 , 121 , 122 , &HE4 , &HF6 , &HF1 , &HFC , &HE0

Nokiamsg1:                                                  'Phone ID  04 03
  Data &H1E , &H00 , &H0C , &H04 , &H00 , &H06 , &H00 , &H01 , &H00 , &H01 , &H01 , &H40
Nokiamsg2:                                                  'SW/HW info  D1 03
  Data &H1E , &H00 , &H0C , &HD1 , &H00 , &H07 , &H00 , &H01 , &H00 , &H03 , &H00 , &H01 , &H41 , &H00
Nokiamsg3:                                                  'SMS - Initiate connection  02  0D
  Data &H1E , &H00 , &H0C , &H02 , &H00 , &H09 , &H00 , &H01
  Data &H00 , &H0D , &H00 , &H00 , &H02 , &H01 , &H42 , &H00
Nokiamsg4:                                                  'SMS - Set CellBroadcast  02 20
  Data &H1E , &H00 , &H0C , &H02 , &H00 , &H07 , &H00 , &H01
  Data &H00 , &H20 , &H02 , &H01 , &H43 , &H00
Nokiamsg5:                                                  'SMS -  Initiate connection  02  0D
  Data &H1E , &H00 , &H0C , &H02 , &H00 , &H09 , &H00 , &H01
  Data &H00 , &H0D , &H01 , &H00 , &H02 , &H01 , &H44 , &H00
Nokiamsg6:                                                  'Phone ID  64 10
  Data &H1E , &H00 , &H0C , &H64 , &H00 , &H06 , &H00 , &H01
  Data &H00 , &H10 , &H01 , &H45

Nokiamsg7:                                                  'Accessory connection 64 12
  Data &H1E , &H00 , &H0C , &H64 , &H00 , &H2F , &H00 , &H01
  Data &H00 , &H12
  Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
  Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
  Data &H4E , &H4F , &H4B , &H49 , &H41 , &H26 , &H4E , &H4F
  Data &H4B , &H49 , &H41 , &H20 , &H61 , &H63 , &H63 , &H65
  Data &H73 , &H73 , &H6F , &H72 , &H79 , &H00 , &H00 , &H00
  Data &H00 , &H01 , &H40 , &H00
Nokiamsg8:                                                  'Delete SMS
  Data &H1E , &H00 , &H0C , &H14 , &H00 , &H08 , &H00 , &H01
  Data &H00 , &H0A , &H02 , &H00 , &H01 , &H00
